<?php $__env->startSection('title','CARRISOFT V2: BON DE COMMANDE'); ?>


<?php $__env->startSection('content'); ?>
    <main class="col-sm-12 ml-sm-auto col-md-12 pt-0" style="text-decoration: none; margin-top: 5px;">
    <h3 class="ml-5"><b><?php echo e(__('messages.HISTORIQUE DES COMMANDES')); ?></b></h3>
        <div class="col-12 col-sm-12 col-md-12">
            <div class="col-12 col-md-8 float-left">
                
            </div>
            <div class="col-12 col-sm-4 col-md-4 float-right">
                <a href="<?php echo e(route('cmde.debut')); ?>" class="btn btn-success"><i class="fa fa-new"></i> <?php echo e(__('messages.Nouvelle commande')); ?></a>
            </div>
        </div>
        <br>

        <div class="info-box mb-1">
            <div class="row input-daterange">
                <div class="col-12 col-md-3">
                    <input type="text" name="from_date" id="from_date" class="form-control" placeholder="<?php echo e(__('messages.Date Debut')); ?>" readonly />
                </div>
                <div class="col-12 col-md-3">
                    <input type="text" name="to_date" id="to_date" class="form-control" placeholder="<?php echo e(__('messages.Date Fin')); ?>" readonly />
                </div>

                <div class="col-12 col-md-6">
                    <button type="button" name="filter" id="filter" class="btn btn-primary"><?php echo e(__('messages.Rechercher')); ?></button>
                    <button type="button" name="refresh" id="reset" class="btn btn-danger"><?php echo e(__('messages.Actualiser')); ?></button>
                </div>
            </div>
            <!-- /.info-box-content -->
        </div>

        <div class="col-md-12">
            <div class="info-box">
                <div class="table-responsive">
                    <table class="table table-striped table-bordered" id="histo_cmde">
                        <thead>
                        <tr class="cart_menu">
                            <td class="description"><?php echo e(__('messages.Date')); ?> </td>
                            <td class="price"><?php echo e(__('messages.Code')); ?></td>
                            <td class="price"><?php echo e(__('messages.cout')); ?></td>
                            <td class="price"><?php echo e(__('messages.Fournisseur')); ?></td>
                            <td class="price"><?php echo e(__('messages.Etat')); ?></td>
                            <td class="price"><?php echo e(__('messages.Taux de satisfaction')); ?></td>
                            <td class="total"><?php echo e(__('messages.Utilisateur')); ?></td>
                            <td><?php echo e(__('messages.Visualiser')); ?></td>
                            <td><?php echo e(__('messages.Observer')); ?></td>
                            <td><?php echo e(__('messages.Editer')); ?></td>
                            <td><?php echo e(__('messages.Imprimer')); ?></td>
                            <td><?php echo e(__('messages.Annuler')); ?></td>
                        </tr>
                        </thead>
                    </table>
                </div>
            </div>
        </div>
        <!--Supprimer le produit -->
        <main id="confirmModal" class="modal fade" role="dialog">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h2 class="modal-title"><?php echo e(__('messages.Confirmation')); ?></h2>
                    </div>
                    <div class="modal-body">
                        <h5 align="center" style="margin:0;"><?php echo e(__('messages.annuler commande')); ?></h5>
                    </div>
                    <div class="modal-body">
                        <label><?php echo e(__('messages.Motif de l annulation')); ?></label>
                        <input type="text" class="form-group form-control" name="mofif" id="motif" required> 
                    </div>
                    <div class="modal-footer">
                        <button type="button" name="ok_button" id="ok_button" class="btn btn-danger"><?php echo e(__('messages.Oui')); ?></button>
                        <button type="button" class="btn btn-primary" data-dismiss="modal"><?php echo e(__('messages.Annuler')); ?></button>
                    </div>
                </div>
            </div>
        </main>

        <!--Info suppression -->
        <main id="infoModal" class="modal fade" role="dialog">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h2 class="modal-title"><?php echo e(__('messages.Information')); ?></h2>
                    </div>
                    <div class="modal-body">
                        <h5 align="center" style="margin:0;"><?php echo e(__('messages.Impossible annuler commande')); ?></h5>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-danger" data-dismiss="modal"><?php echo e(__('messages.Fermer')); ?></button>
                    </div>
                </div>
            </div>
        </main>

        <!--Info cmde -->
        <main id="infosCmdeModal" class="modal fade" role="dialog">
            <div class="modal-dialog modal-lg">
                <div class="modal-content">
                    <div class="modal-header">
                        <?php echo e(__('messages.Details commande')); ?>

                    </div>
                    <div class="modal-body">
                        <div class="form-group">
                            <div class="col-md-12">
                                <table id="details_cmde" class="table">

                                </table>
                            </div>
                        </div>

                        <div class="form-group" align="center">
                            <button type="button" name="soumettre_button" id="soumettre_button" class="btn btn-success"><?php echo e(__('messages.Soumettre')); ?></button>
                            <button type="button" class="btn btn-danger" data-dismiss="modal"><i class="fa fa-windows-close"></i><?php echo e(__('messages.Quitter')); ?></button>
                        </div>
                    </div>
                </div>
            </div>
        </main>
        <!--Ajouter une observation -->
        <div id="observationModal" class="modal fade" role="dialog">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title">Noter une observation</h4>
                    </div>
                    <div class="modal-body">
                        <span id="form_result"></span>
                        <form method="post" id="observation_form" class="form-horizontal">
                            <?php echo csrf_field(); ?>

                            <div class="form-group">
                                <label class="control-label col-md-12" ><?php echo e(__('messages.Infos Commande')); ?> : </label>
                                <input type="text" name="infocmde" id="infocmde" class="form-control" readonly/>
                            </div>

                            <div class="form-group">
                                <label class="control-label col-md-12" ><?php echo e(__('messages.Date Observation')); ?> : </label>
                                <input type="date" name="date" id="date" class="form-control" required="required" value="<?php echo e(date('d-m-Ý')); ?>"/>
                            </div>
                            <div class="form-group">
                                <label class="control-label col-md-12" ><?php echo e(__('messages.Observation ')); ?> : </label>
                                <input type="text" name="observation" id="observation" class="form-control" required="required"/>
                            </div>


                            <div class="form-group" align="center">
                                <input type="hidden" name="commande_id" id="commande_id" />
                                <input type="hidden" name="source_action" id="source_action" value="1"/>
                                <input type="hidden" name="centre_id" id="centre_id" />
                                <input type="submit" name="action_button" id="action_button" class="btn btn-success" value="<?php echo e(__('messages.Enregistrer')); ?>" />
                                <button type="button" class="btn btn-danger" data-dismiss="modal"><i class="fa fa-windows-close"></i><?php echo e(__('messages.Quitter')); ?></button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </main>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('extra-js'); ?>
    <script>
        var cmde_num=0;
        $(document).ready(function(){
            $('.input-daterange').datepicker({
                todayBtn:'linked',
                format:'yyyy-mm-dd',
                autoclose:true
            });

            load_data();

            function load_data(from_date = '', to_date = '') {
                $('#histo_cmde').DataTable({
                    processing: true,
                    serverSide: true,
                    ajax: {
                        url:'<?php echo e(route("cmde.histo")); ?>',
                        data:{from_date:from_date, to_date:to_date}
                    },
                    columns: [
                        {
                            data:'date_commande',
                            name:'date_commande'
                        },
                        {
                            data:'code',
                            name:'code'
                        },
                        {
                            data:'montant',
                            name:'montant'
                        },
                        {
                            data:'nom',
                            name:'nom'
                        },
                        {
                            data:'etat',
                            name:'etat'
                        },
                        {
                            data:'taux',
                            name:'taux'
                        },
                        {
                            data:'name',
                            name:'name'
                        },
                        {
                            data:'commande_id',
                            name:'commande_id',
                            render:function (data, type, row) {
                                return "<a href='#' id='"+row.commande_id+"' class='btn btn-warning infos'><i class='fa fa-info'></i></a>"}
                        },
                        {
                            data:'commande_id',
                            name:'commande_id',
                            render:function (data, type, row) {
                                return "<a href='#' id='"+row.commande_id+"' class='btn btn-dark observer'><i class='fa fa-info'></i></a>"}
                        },
                        {
                            data:'commande_id',
                            name:'commande_id',
                            render:function (data, type, row) {
                                return "<a href='cmde/"+row.commande_id+"/edit' class='btn btn-success'><i class='fa fa-edit'></i></a>"}
                        },
                        {
                            data:'commande_id',
                            name:'commande_id',
                            render:function (data, type, row) {
                                return "<a href='cmde/"+row.commande_id+"' class='btn btn-info'><i class='fa fa-print'></i></a>"}
                        },
                        {
                            data:'commande_id',
                            name:'commande_id',
                            render:function (data, type, row) {
                                return "<a href='#' id='"+row.commande_id+"' class='btn btn-danger delete'><i class='fa fa-trash'></i></a>"}
                        }

                    ],
                    'rowCallback': function(row, data, index) {
                        if (data.cmde_etat == 'Livree') {
                            $(row).find('td:eq(4)').css('background-color', 'green').css('color', 'white');
                        }
                        if (data.cmde_etat == 'Annulee') {
                            $(row).find('td:eq(4)').css('background-color', 'red').css('color', 'white');
                        }
                        if (data.cmde_etat == 'Partielle') {
                            $(row).find('td:eq(4)').css('background-color', 'yellow').css('color', 'black');
                        }
                    }
                });
            }

            $('#filter').click(function(){
                var from_date = $('#from_date').val();
                var to_date = $('#to_date').val();
                if(from_date != '' && to_date != '')
                {
                    $('#histo_cmde').DataTable().destroy();
                    load_data(from_date, to_date);
                }
                else
                {
                    alert('Selectionner la periode');
                }
            });

            $('#reset').click(function(){
                $('#from_date').val('');
                $('#to_date').val('');
                $('#histo_cmde').DataTable().destroy();
                load_data();
            });

            var commande_id;
            $(document).on('click', '.delete', function(){
                commande_id = $(this).attr('id');
                $.ajax({
                    url:"cmde.rech_cmde/"+commande_id,
                    dataType:"json",
                    success:function(data)
                    {
                        if ((data.etat!='Encours') ){
                            $('#infoModal').modal('show');
                        }else {
                            $('.modal-title').text("Confirmation");
                            $('#ok_button').text('Oui');
                            $('#confirmModal').modal('show');
                        }
                    }
                })
            });

            $('#ok_button').click(function(){
                var motif =  document.getElementById("motif").value;
                $.ajax({
                    url:"cmde.annuler_cmde/"+commande_id+"/"+motif,
                    beforeSend:function(){
                        $('#ok_button').text('Suppression...');
                    },
                    success:function(data)
                    {
                        setTimeout(function(){
                            $('#confirmModal').modal('hide');
                            $('#histo_cmde').DataTable().ajax.reload();
                        }, 500);
                    }
                })
            });

            $('#soumettre_button').click(function(){
                //console.log(cmde_num)
                $.ajax({
                    url:"cmde.soumettre/"+cmde_num,
                    beforeSend:function(){
                        $('#ok_button').text('oumission...');
                    },
                    success:function(data)
                    {
                        setTimeout(function(){
                            $('#infosCmdeModal').modal('hide');
                            $('#histo_cmde').DataTable().ajax.reload();
                        }, 500);
                    }
                })
            });

            $(document).on('click', '.infos', function(){
                cmde_num = $(this).attr('id');
                $.ajax({
                    url:"cmde.rech_cmde/"+cmde_num,
                    dataType:"json",
                    success:function(data)
                    {
                        console.log(data.etat)
                        if ((data.etat!='Encours')){
                            document.getElementById("soumettre_button").disabled=true
                        }else {
                            document.getElementById("soumettre_button").disabled=false
                        }
                    }
                })
                $('#details_cmde').load('cmde.infos/'+cmde_num);
                $('#infosCmdeModal').modal('show');
            });

            $(document).on('click', '.observer', function(){
                var id = $(this).attr('id');

                $('#form_result').html('');
                $.ajax({
                    url:"val.cmde/"+id,
                    dataType:"json",
                    success:function(data){
                        $('.modal-title').text("<?php echo e(__('messages.Noter une observation')); ?>");
                        $('#infocmde').val('Cmde Num '+data.code+' / Centre: '+data.nom_centre);
                        $('#commande_id').val(data.commande_id);
                        $('#centre_id').val(data.centre_id);
                        $('#observation').val('');
                        $('#source_action').val("2");
                        $('#observationModal').modal('show');
                        setTimeout(function() {$('#observation').focus();}, 200);
                    }
                })
            });

            $('#observation_form').on('submit', function(event){
                event.preventDefault();
                $.ajax({
                    url:"<?php echo e(route('val.obsv')); ?>",
                    method:"POST",
                    data: new FormData(this),
                    contentType: false,
                    cache:false,
                    processData: false,
                    dataType:"json",
                    success:function(data)
                    {
                        var html = '';
                        if(data.errors)
                        {
                            html = '<div class="alert alert-danger">';
                            for(var count = 0; count < data.errors.length; count++)
                            {
                                html += '<p>' + data.errors[count] + '</p>';
                            }
                            html += '</div>';
                        }
                        if(data.error)
                        {
                            html = '<div class="alert alert-danger">' + data.error + '</div>';
                        }
                        if(data.success)
                        {
                            html = '<div class="alert alert-success">' + data.success + '</div>';
                            $('#observation_form')[0].reset();
                            $('#observationModal').modal('hide');
                            $('#liste_cmde').DataTable().ajax.reload();
                        }
                        $('#form_result').html(html);
                    }
                })
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.adminlayout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\gas_online\resources\views/commande/histo.blade.php ENDPATH**/ ?>